import librosa
import soundfile as sf
import os
import librosa.display
import numpy as np
from math import *

chem = "/nfs/NAS6/SABIOD/SITE/Bird_GUADELOUPE_OFB/Enregistreurs autonomes"
liststation = os.listdir(chem) # MTP, PM, P-M


chemin = []
for i in liststation:
    listpassage = os.listdir(chem+"/"+i)
    for j in listpassage:
        listnum = os.listdir(chem+"/"+i+"/"+j)
        for k in listnum:
            listfichier = os.listdir(chem+"/"+i+"/"+j+"/"+k+"/Data")
            for l in listfichier:
                chemin.append(chem+"/"+i+"/"+j+"/"+k+"/Data/"+l)

def crea():
    for i in range (len(chemin)):
        basename = os.path.basename(chemin[i])
        soloname = os.path.splitext(basename)[0]
        path = os.path.normpath(chemin[i])
        pathsep = path.split(os.sep)
        if not os.path.exists("/nfs/NAS3/SABIOD/SITE/Bird_GUADELOUPE_copie/" + pathsep[7]+"/"+pathsep[8]+"/"+pathsep[9]):
            os.makedirs("/nfs/NAS3/SABIOD/SITE/Bird_GUADELOUPE_copie/" + pathsep[7]+"/"+pathsep[8]+"/"+pathsep[9])


def decoup ():
    duree = 4 # duree de la fenetre de decoupe #####################################################"
    for i in range (len(chemin)): 

        n, sr = librosa.load(chemin[i], sr=24000)
        dur = librosa.get_duration(y=n, sr=sr)
        long = ceil(dur)  #librairie math (arrondi)

        for m in range (duree):   ##4
            if long%duree == 0: # multiple de 4
                for j in range (0,long,duree):
                    y, sr = librosa.load(chemin[i], sr=24000, offset = j, duration = duree)
                    a = librosa.get_duration(y=y, sr=sr)
                    if a < duree :
                        break
                    else :
                        basename = os.path.basename(chemin[i])
                        soloname = os.path.splitext(basename)[0]
                        path = os.path.normpath(chemin[i])
                        pathsep = path.split(os.sep)
                        sf.write("/nfs/NAS3/SABIOD/SITE/Bird_GUADELOUPE_copie/" + pathsep[7]+"/"+pathsep[8]+"/"+pathsep[9]+"/"+soloname +"_" + str(j) + ".wav", y, 24000)
            else :
                long = long + 1

#crea()
#decoup()