from tqdm import trange
import numpy as np
import matplotlib.pyplot as plt
import pandas as pd
import librosa
import librosa.display
import os


def logfin():
    df = pd.read_pickle("_HP_fus_SPCG_16_99_PM1.preds")   ##"CODE BON/
    x = df.pred
    y = df.fn
    a = ["Moqueur_grivotte","Paruline_caféiette","Colombe_rouviolette","Colombe_à_croissants","Pic_de_Guadeloupe","Tyran_janeau","Saltator_gros_bec"]

    df['date'] = '0'
    for i in trange(len(y)):
        liste = df.fn[i].split("_")
        df.date[i] = liste[1]

    for i in range(len(a)):
        for j in range(len(x[i])):
            df[a[i]] = '0'

    for k in trange (len(x)):
        for i in range(len(a)):
            df.eval(a[i])[k] = x[k][i]    #colonne , ligne

    del df['pred']

    df.to_csv("./csv/test1.csv", index=False)

#/home/nico/Bureau/Stage/mnt/nfs/NAS6/SABIOD/SITE/Bird_GUADELOUPE_OFB/Enregistreurs autonomes/Petit Marquisat (PM)/Premier passage/PM1 (SMA01303)
# /home/nico/Bureau/Stage/mnt/nfs/NAS6/SABIOD/SITE/Bird_GUADELOUPE_OFB/Enregistreurs autonomes/Petit-Marquisat (PM)/Premier passage suite ------------PM3 (SMA02500)--------- PM5 (SMA02491)--------PM7 (SMA02543)----------PM9 (SMA02593)
def conc ():
    fichier = "./forward/PM9.csv" ###########################################"
    df = pd.read_csv(fichier)
    col = ["fn"]
    doss = "../../../nfs/NAS6/SABIOD/SITE/Bird_GUADELOUPE_OFB/Enregistreurs autonomes/Petit-Marquisat (PM)/Premier passage suite/PM9 (SMA02593)/Data/"  #################################################### ici changer la c pour CS P
    listdata = os.listdir(doss)
    for j in range(len(listdata)):
        name = listdata[j]

        #basename = os.path.basename(name)
        #soloname = os.path.splitext(basename)[0]
        #path = os.path.abspath(name)  # chemin complet
        #chem = os.path.dirname(path)  # chemin sans le fichier
        #chemin = chem + doss[1:-1]
        #bon = chemin + "/" + basename
        dfnew = pd.DataFrame([[name]], columns=col) # new ligne
        df = pd.concat([df,dfnew]) # concatene

    df.to_csv(fichier, index=False)


def crea():
    df = pd.read_pickle("./forward/resultats/_HP_fus_SPCG_16_99_MPT1-s.preds")       #########

    x = df.pred
    y = [1,2,3,4,5,6,7,8]
    a = ["Moqueur_grivotte","Paruline_caféiette","Colombe_rouviolette","Colombe_à_croissants","Pic_de_Guadeloupe","Tyran_janeau","Saltator_gros_bec"]

    df['maxval'] = '0'
    for i in trange(len(x)):
        val = (df.pred[i].max())
        df.maxval[i] = val

    df['label'] = '0'
    for i in trange(len(x)):
        ind = np.where(df.pred[i] == df.maxval[i])
        df.label[i] = ind[0][0]

    #print(df[df.maxval > 5].groupby('fn').count())

    v = df[df.maxval > 20]   #########################################"""
    v.to_pickle("./forward/resultats/_HP_fus_SPCG_16_99_MPT1-sV2.preds")      #################

    #pour un scatter avec toutes les predictions

def plot():
df = pd.read_pickle("./forward/resultats/_HP_fus_SPCG_16_99_MPT9.preds")                      #################
a = ["Moqueur_grivotte", "Paruline_caféiette", "Colombe_rouviolette", "Colombe_à_croissants", "Pic_de_Guadeloupe",
     "Tyran_janeau", "Saltator_gros_bec"]
x = df.pred
print(x)
for i in trange(len(x)):
    plt.scatter(df.pred[i], a, marker="x")
plt.show()
plt.savefig("_HP_SPC_16_99_imgMPT9.svg")        ##############"


def fig():
    outFolder = './forward/specMPT/'  ############
    #os.system('rm -R '+outFolder+'*')
    #df = pd.read_csv('annotations_13_04_augmentation_swop_v2_5886_annots.csv')
    df = pd.read_pickle("./forward/resultats/_HP_fus_SPCG_16_99_MPT1-sV2.preds")  #####################"
    # read annotation

    chemin = "../../../nfs/NAS6/SABIOD/SITE/Bird_GUADELOUPE_OFB/Enregistreurs autonomes/Morne Paul Thomas (MPT)/Second passage/MPT1 (SMA01303)/Data/"  ##########"

    for i in trange(len(df.pred)):
        idx = df.label.iloc[i]
        file = df.fn.iloc[i]
        time = df.offset.iloc[i]

        loader, sr = librosa.load(chemin + file,offset=time, duration=4, sr=24000)
        D = librosa.stft(loader)

        plt.figure()

        #plt.imshow(abs(D), origin='lower', aspect='auto')

        img = librosa.display.specshow(D, y_axis='linear', x_axis='time', sr=sr)
        plt.colorbar(img, format="%+2.f dB")

        plt.savefig(outFolder+str(idx)+"/"+'annoted_'+file[:-4]+"_"+str(idx)+"_"+str(time)+".svg")
        plt.close()

conc()
#crea()
#fig()
#plot()
