import librosa
import soundfile as sf
import os
import librosa.display
import numpy as np
import matplotlib.pyplot as plt
from pydub import AudioSegment
from math import *
import random
from pedalboard import (
    Pedalboard,
    Convolution,
    Compressor,
    Chorus,
    Distortion,
    Reverb,
    Limiter,
    Delay,
    Phaser)


listxeno = os.listdir("./xeno")
listbruits = os.listdir("./bruits")
listconv =  os.listdir("./conv")
listconvdec = os.listdir("./convdecoup")

#transforme tous les son du fichier xeno en wav 24000Hz dans le fichier conv
def convertion ():
    for i in range (len(listxeno)):
        name = listxeno[i]
        basename = os.path.basename(name)
        soloname = os.path.splitext(basename)[0]
        y, sr = librosa.load("./xeno/"+name, sr=24000)  # attention si on met pas le sr ici de base il est de 22050
        sf.write("./conv/"+soloname+".wav", y, 24000)

def decoup ():
    duree = 4 # duree de la fenetre de decoupe #####################################################"
    for i in range (len(listconv)):
        name = listconv[i]
        basename = os.path.basename(name)
        soloname = os.path.splitext(basename)[0]

        n, sr = librosa.load("./conv/" + name, sr=24000)
        dur = librosa.get_duration(y=n, sr=sr)
        long = ceil(dur)

        for m in range (duree):   ##4
            if long%duree == 0:
                for j in range (0,long,duree):
                    y, sr = librosa.load("./conv/" + name, sr=24000, offset = j, duration = duree)
                    a = librosa.get_duration(y=y, sr=sr)
                    if a < duree :
                        b = duree - a
                        z, sr = librosa.load("./conv/" + name, sr=24000, offset = 0, duration = b)
                        x = np.append(y,z)

                        sf.write("./convdecoup/" + soloname + "_" + str(j) + ".wav", x, 24000)
                    else :
                        sf.write("./convdecoup/" + soloname + "_" + str(j) + ".wav", y, 24000)
            else :
                long = long + 1


def effets ():
    for j in range(2):
        if j == 0:
            ext = "CS"
        else:
            ext = "LS"
        name = os.listdir("./bruits/" + ext + "/")
        soloname = os.path.splitext(name[0])[0]
        audio, sample_rate = sf.read("./bruits/" + ext + "/" + name[0])  # attention si on met pas le sr ici de base il est de 22050

        eff = ["Reverb","Distortion","Compressor","Limiter","Delay"]
        for i in range(5):
            if i == 0:
                board = Pedalboard([Reverb()])
            elif i == 1:
                board = Pedalboard([Distortion()])
            elif i == 2:
                board = Pedalboard([Compressor()])
            elif i == 3:
                board = Pedalboard([Limiter()])
            elif i == 4:
                board = Pedalboard([Delay()])

            # Run the audio through this pedalboard!
            effected = board(audio, sample_rate)

            # Write the audio back as a wav file:
            with sf.SoundFile("./bruits/" + ext + "/" + soloname + "_" + eff[i] + ".wav", 'w', samplerate=sample_rate,
                              channels=len(effected.shape)) as f:
                f.write(effected)


def superpositionCS(): # ajoute son et bruit
    for i in range (len(listconv)):
        name = listconv[i]
        bru = listbruits[0] # 0 = CS , 1 = LS

        basename = os.path.basename(name)
        soloname = os.path.splitext(basename)[0]

        sound1 = AudioSegment.from_file("./conv/" + name)
        sound2 = AudioSegment.from_file("./bruits/" + bru)
        combined = sound1.overlay(sound2)
        combined.export("./CS/"+soloname+".wav", format='wav')

def supdecCS():
    for i in range (len(listconvdec)):
        name = listconvdec[i] #changer ca
        bru = listbruits[0] # 0 = CS , 1 = LS

        basename = os.path.basename(name)
        soloname = os.path.splitext(basename)[0]

        sound1 = AudioSegment.from_file("./convdecoup/" + name)
        sound2 = AudioSegment.from_file("./bruits/" + bru)
        combined = sound1.overlay(sound2)
        combined.export("./decCS/"+soloname+".wav", format='wav')


def AMPLIsupalecCS():
    for i in range (len(listconvdec)):
        name = listconvdec[i] #changer ca
        bru = listbruits[0] # 0 = CS , 1 = LS

        basename = os.path.basename(name)
        soloname = os.path.splitext(basename)[0]

        sound1 = AudioSegment.from_file("./convdecoup/" + name)

        bruits = os.listdir("./bruits/" + bru)
        for j in range(len(listconvdec)):
            sound2 = AudioSegment.from_file("./bruits/" + bru + bruits[random.randint(1, 6)])
            #pas finis############################################################################"
            combined = sound1.overlay(sound2)
            combined.export("./aleCS/"+soloname+".wav", format='wav')


def supalecCS():
    for i in range(len(listconvdec)):
        name = listconvdec[i]  # changer ca
        bru = listbruits[0]  # 0 = CS , 1 = LS

        basename = os.path.basename(name)
        soloname = os.path.splitext(basename)[0]

        sound1 = AudioSegment.from_file("./convdecoup/" + name)
        s2 = []
        bruits = os.listdir("./bruits/" + bru)
        for j in range(len(listconvdec)):
            s2.append("./bruits/" + bru + "/" + bruits[random.randint(0, 5)])

        sound2 = AudioSegment.from_file(s2[i])
        combined = sound1.overlay(sound2)
        combined.export("./aleCS/" + soloname + ".wav", format='wav')

def supalecLS():
    for i in range(len(listconvdec)):
        name = listconvdec[i]  # changer ca
        bru = listbruits[1]  # 0 = CS , 1 = LS

        basename = os.path.basename(name)
        soloname = os.path.splitext(basename)[0]

        sound1 = AudioSegment.from_file("./convdecoup/" + name)
        s2 = []
        bruits = os.listdir("./bruits/" + bru)
        for j in range(len(listconvdec)):
            s2.append("./bruits/" + bru + "/" + bruits[random.randint(0, 5)])

        sound2 = AudioSegment.from_file(s2[i])
        combined = sound1.overlay(sound2)
        combined.export("./aleLS/" + soloname + ".wav", format='wav')

def superpositionLS():
    for i in range(len(listbruits)):
        name = listconv[i]  # changer ca
        bru = listbruits[1]  # 0 = CS , 1 = LS

        basename = os.path.basename(name)
        soloname = os.path.splitext(basename)[0]

        sound1 = AudioSegment.from_file("./conv/" + name)
        sound2 = AudioSegment.from_file("./bruits/" + bru)
        combined = sound1.overlay(sound2)
        combined.export("./LS/" + soloname + ".wav", format='wav')

def supdecLS():
    for i in range(len(listconvdec)):
        name = listconvdec[i]  # changer ca
        bru = listbruits[1]  # 0 = CS , 1 = LS

        basename = os.path.basename(name)
        soloname = os.path.splitext(basename)[0]

        sound1 = AudioSegment.from_file("./convdecoup/" + name)
        sound2 = AudioSegment.from_file("./bruits/" + bru)
        combined = sound1.overlay(sound2)
        combined.export("./decLS/" + soloname + ".wav", format='wav')

# ca c pour CS faire de mm pour LS ou ptetre le mettre dans la fonction davant a voir
def sepCS ():
    listeCS = os.listdir("./CS")
    for i in range(len(listeCS)):
        CS = listeCS[i] #changer la valeur
        basename = os.path.basename(CS)
        soloname = os.path.splitext(basename)[0]

        y, sr = librosa.load("./CS/" + CS)
        D = librosa.stft(y)
        H, P = librosa.decompose.hpss(D, mask=True)

        P = P < 0.2
        plt.imshow(P, origin="lower")
        plt.savefig("./specCS/H/spectroCS_H_" + soloname)
        plt.close()

        plt.figure()
        H = H < 0.2
        plt.imshow(H, origin="lower")
        plt.savefig("./specCS/P/spectroCS_P_" + soloname)
        plt.close()

        plt.figure()
        D = H + P
        plt.imshow(D, origin="lower")
        plt.savefig("./specCS/HP/spectroCS_HP_" + soloname)
        plt.close()

def dataCS ():
    listeCS = os.listdir("./decCS")
    for i in range(len(listeCS)):
        CS = listeCS[i]
        basename = os.path.basename(CS)
        soloname = os.path.splitext(basename)[0]

        y, sr = librosa.load("./decCS/" + CS)
        D = librosa.stft(y)
        H, P = librosa.decompose.hpss(D, mask=False) ###

        #P = P < 0.2
        np.save("./dataCS/P/dataCS_P_" + soloname,P)

        #H = H < 0.2
        np.save("./dataCS/H/dataCS_H_" + soloname,H)

        #D = H + P
        np.save("./dataCS/HP/dataCS_HP_" + soloname,D)

def datadecCS ():
    listeCS = os.listdir("./aleCS") ########""""" attention mm nom mais pas mm fichiers
    for i in range(len(listeCS)):
        CS = listeCS[i]
        basename = os.path.basename(CS)
        soloname = os.path.splitext(basename)[0]

        y, sr = librosa.load("./aleCS/" + CS)
        D = librosa.stft(y)
        H, P = librosa.decompose.hpss(D, mask=False)

        #P = P < 0.2
        np.save("./dataCSale/H/dataCS_H_" + soloname,H)

        #H = H < 0.2
        np.save("./dataCSale/P/dataCS_P_" + soloname,P)

        #D = H + P
        np.save("./dataCSale/HP/dataCS_HP_" + soloname,D)


def sepLS ():
    listeLS = os.listdir("./LS")
    for i in range(len(listeLS)):
        LS = listeLS[i] #changer la valeur
        basename = os.path.basename(LS)
        soloname = os.path.splitext(basename)[0]

        y, sr = librosa.load("./LS/" + LS)
        D = librosa.stft(y)
        H, P = librosa.decompose.hpss(D, mask=True)

        #penser a ajouter les legendes du graph
        P = P < 0.2
        plt.imshow(P, origin="lower")
        plt.savefig("./specLS/H/spectroLS_H_" + soloname)
        plt.close()

        plt.figure()
        H = H < 0.2
        plt.imshow(H, origin="lower")
        plt.savefig("./specLS/P/spectroLS_P_" + soloname)
        plt.close()

        plt.figure()
        D = H + P
        plt.imshow(D, origin="lower")
        plt.savefig("./specLS/HP/spectroLS_HP_" + soloname)
        plt.close()

def dataLS ():
    listeLS = os.listdir("./decLS")
    for i in range(len(listeLS)):
        LS = listeLS[i]
        basename = os.path.basename(LS)
        soloname = os.path.splitext(basename)[0]

        y, sr = librosa.load("./decLS/" + LS)
        D = librosa.stft(y)
        H, P = librosa.decompose.hpss(D, mask=True)

        #P = P < 0.2
        np.save("./dataLS/P/dataLS_P_" + soloname,P)

        #H = H < 0.2
        np.save("./dataLS/H/dataLS_H_" + soloname,H)

        #D = H + P
        np.save("./dataLS/HP/dataLS_HP_" + soloname,D)

def datadecLS (): ######################## idem attention mm nom
    listeLS = os.listdir("./aleLS")
    for i in range(len(listeLS)):
        LS = listeLS[i]
        basename = os.path.basename(LS)
        soloname = os.path.splitext(basename)[0]

        y, sr = librosa.load("./aleLS/" + LS)
        D = librosa.stft(y)
        H, P = librosa.decompose.hpss(D, mask=False)

        #P = P < 0.2
        np.save("./dataLSale/H/dataLS_H_" + soloname,H)

        #H = H < 0.2
        np.save("./dataLSale/P/dataLS_P_" + soloname,P)

        #D = H + P
        np.save("./dataLSale/HP/dataLS_HP_" + soloname,D)


#convertion()

#decoup()

#effets()

#superpositionCS()

#superpositionLS()

#supdecCS()
#supdecLS()

#supalecCS()
#supalecLS()
#sepCS()
#sepLS()

#dataCS()
#dataLS()

#datadecCS()
#datadecLS()


