
function saveTextAsFile(textToWrite)
{
	var textFileAsBlob = new Blob([textToWrite], {type:'text/plain;charset=utf-8'});
	var fileNameToSaveAs = "croute.stl";

	var downloadLink = document.createElement("a");
	downloadLink.download = fileNameToSaveAs;
	downloadLink.innerHTML = "Download File";
	if (window.webkitURL != null)
	{
		// Chrome allows the link to be clicked
		// without actually adding it to the DOM.
		downloadLink.href = window.webkitURL.createObjectURL(textFileAsBlob);
	}
	else
	{
		// Firefox requires the link to be added to the DOM
		// before it can be clicked.
		downloadLink.href = window.URL.createObjectURL(textFileAsBlob);
		//downloadLink.onclick = destroyClickedElement;
		downloadLink.style.display = "none";
		document.body.appendChild(downloadLink);
	}

	downloadLink.click();
}


function exportSTL()
{
	var cRet=String.fromCharCode(13)+String.fromCharCode(10);
	var cTab=" ";
	var filename="croute3d.stl";
	var URItexte="solid croute"+cRet;
	var texte;
	
	var nbf=geomFond.faces.length;
		
	var v=new Array();
	
	var x,y,z;
	var face;
	
	for (var i=0;i<nbf;i++)
	{
		face=geomFond.faces[i];
		texte="";
		x=Math.round(face.normal.x*100)/100;
		y=Math.round(face.normal.y*100)/100;
		z=Math.round(face.normal.z*100)/100;
		texte+=cTab+"facet normal "+x+" "+y+" "+z+cRet;
		texte+=cTab+cTab+"outer loop"+cRet;
		v[0]=face.a;
		v[1]=face.b;
		v[2]=face.c;
		
		for (var j=0;j<3;j++) {
			var vert=geomFond.vertices[v[j]];
			texte+=cTab+cTab+cTab+"vertex ";
			x=Math.round(vert.x)/100;
			y=Math.round(vert.y)/100;
			z=Math.round(vert.z)/100;
			texte+=x+" "+y+" "+z;
			texte+=cRet;					
		}
		URItexte+=texte;
		URItexte+=cTab+cTab+"endloop"+cRet;
		URItexte+=cTab+"endfacet"+cRet;
		
	}
		
	URItexte+="endsolid croute";
	
	saveTextAsFile (URItexte);
	
	//var pom = document.createElement('a');
	//pom.setAttribute('href', 'data:text/plain;charset=utf-8,' + URItexte);
	
	//pom.setAttribute('download', filename);
	//pom.click();
}