﻿var latiRef= 42.936717;
var longiRef =   6.317767;
var altiDemi = -500;
var opaDemi=0.3;

var tDemiSph=new Array();
function ajoutDemiSph (lati,longi,alti,r,coul,opa,nom,nc) {
	// nc = nombre de rangées de cercles
	var resol=64;
	var hemi, cercle,obj;
	
	var c=new Object();
	var nom=nom||"(sans nom)";
	var xy=new Object();

	
	c.lati=lati;
	c.longi=longi;
	xy=latlong2xy(c);
	var x=xy.x;
	var z=-xy.y;
	var y=alti*echelleZ;
		
	
	var materialSph = new THREE.MeshBasicMaterial({
			color: coul,
			opacity  :opa,
			wireframe:false,
			transparent : true,
			side:THREE.DoubleSide
	});

	// demi sphère
	var geometry = new THREE.SphereGeometry( r, resol,16*nc);
	// on supprime la moitié supérieure
	var nf=geometry.faces.length;
	var n1=Math.floor(nf/2);
	var n2=Math.floor(nf*0.1);
	geometry.faces.splice (0,n1);
	// on supprime le bas
	nf=geometry.faces.length;
	n1=resol*2;
	n2=Math.floor(nf-n1);
	geometry.faces.splice (n1,n2);
	
	var geom2 = new THREE.BufferGeometry().fromGeometry( geometry );
	
	obj = new THREE.Mesh( geom2, materialSph );
	
	obj.position.x=x;
	obj.position.y=y;
	obj.position.z=z;
	obj.alti=alti;
	scene.add( obj);
	
	return obj;
}

function ajouteSphere (lati,longi,alti,r,coul,opa,nom) {
		var c=new Object();
		var nom=nom||"(sans nom)";
		var xy=new Object();
		var geometry = new THREE.SphereGeometry( r, 16,16 );
		var material = new THREE.MeshPhongMaterial( {
			color: coul,
			emissive: coul&0x3f3f3f,
			transparent : true,
			opacity:opa
		} );
		
		var sphere = new THREE.Mesh( geometry, material );
		
		c.lati=lati;
		c.longi=longi;
		xy=latlong2xy(c);
		var x=xy.x;
		var z=-xy.y;

		sphere.position.x=x;
		sphere.position.z=z;
		sphere.alti=alti;
		sphere.lati=lati;
		sphere.longi=longi;
		sphere.nom=nom;
		sphere.position.y=alti*echelleZ;
		sphere.ciblePossible=true;
		scene.add( sphere );
		return sphere;
}

function ajouteSphereRel (dx,dy,alti,r,coul,opa,nom) {
		var c=new Object();
		var nom=nom||"(sans nom)";
		var xy=new Object();
		var geometry = new THREE.SphereGeometry( r, 16,16 );
		var material = new THREE.MeshPhongMaterial( {
			color: coul,
			emissive: coul&0x3f3f3f,
			transparent : true,
			opacity:opa
		} );
		
		var sphere = new THREE.Mesh( geometry, material );
		
		c.lati=latiRef;
		c.longi=longiRef;
		xy=latlong2xy(c);
		
		xy.x+=dx;
		xy.y+=dy;
		
		x=xy.x;
		z=-xy.y;
		
		
		
		sphere.position.x=x;
		sphere.position.z=z;
		sphere.alti=alti;
		sphere.dx=dx;
		sphere.dy=dy;
		sphere.posRel=true;
		sphere.nom=nom;
		sphere.position.y=alti*echelleZ;
		sphere.ciblePossible=true;
		scene.add( sphere );
		return sphere;
}

function creeCachalots () {
	var decal=0.012;
	ajouteCachTaille ("20120917",42.9673,5.6396,11.6);
	ajouteCachTaille ("20120917",42.9673,5.6396+decal,11.52);
	ajouteCachTaille ("20121006",42.9128,5.6958,11.3);
	ajouteCachTaille ("20120710",42.9562,5.9823,11.85);
	ajouteCachTaille ("20120802",42.9306,5.9598,11.90);
	ajouteCachTaille ("20120802",42.9306,5.9598+decal,11.74);
	ajouteCachTaille ("20120126",42.8791,5.9965,11.46);
	ajouteCachTaille ("20120126",42.8791,5.9965+decal,11.21);
	ajouteCachTaille ("20120923",42.8252,6.0185,12.93);
	ajouteCachTaille ("20110831",42.8931,6.3068,12.5);
	ajouteCachTaille ("20110519",42.9321,6.4002,12.86);
	ajouteCachTaille ("20110519",42.9321,6.4002+decal,11.32);
	ajouteCachTaille ("20110802",42.9361,6.5524,11.45);
	ajouteCachTaille ("20120530",43.0164,6.5710,11.28);
	ajouteCachTaille ("20110506",43.1072,6.5621,11.88);
	ajouteCachTaille ("20120823",42.9045,6.0281,-1);
	ajouteCachTaille ("20120504",42.8566,5.9972,-1);
	ajouteCachTaille ("20120606",43.0163,6.5184,-1);
}

function componentToHex(c) {
    var hex = c.toString(16);
    return hex.length == 1 ? "0" + hex : hex;
}

function rgbToVal(r, g, b) {
    return ("0x" + componentToHex(r) + componentToHex(g) + componentToHex(b))*1;
}

function rgbToHex(r, g, b) {
    return ("#" + componentToHex(r) + componentToHex(g) + componentToHex(b));
}

function tailleToCoul (taille,mode) {
	if (taille<0) {return rgbToVal(100,100,100);}
	taille=taille-12;
	taille=taille/2+12;
	var r=Math.round(400-Math.abs(taille-12.1)*300);
	if (r>255) {r=255;}
	var g=0;
	if (taille<11.6) {g=255;} else {
		g=Math.round(255-(taille-11.6)*172);
	}
	var b=Math.round(175-(taille-11)*90);
	if (b<0) {b=0;}
	//console.log (r+" "+g+" "+b);
	if (mode==0) {
		return rgbToVal(r,g,b);
	} else {
		return rgbToHex(r,g,b);
	}
}

function ajouteCachTaille (date,lati,longi,taille) {
	// ajoute un petit cube pour un cachalot
	// coloration selon la taille
	var aa=800;
	var bb=400;
	var cc=800;
	var opa=0.75;
	var alti=0;
	var coul=tailleToCoul(taille,0);
	if (taille<0) {taille="???";}
	var texte=date+"\nPhyseter\n(size : "+taille+"m)";
	ajouteCube (lati,longi,alti,aa,bb,cc,coul,opa,texte);
}

function ajouteCube (lati,longi,alti,aa,bb,cc,coul,opa,texte) {
		var c=new Object();
		var xy=new Object();
		var geometry = new THREE.CubeGeometry(aa, bb, cc );
		var material = new THREE.MeshPhongMaterial( {
			color: coul,
			emissive: coul&0x7f7f7f,
			transparent : true,
			opacity:opa
		} );
		
		
		var cube = new THREE.Mesh( geometry, material );
		
		c.lati=lati;
		c.longi=longi;
		xy=latlong2xy(c);
		x=xy.x;
		z=-xy.y;

		cube.position.x=x;
		cube.position.z=z;
		cube.alti=alti;
		cube.lati=lati;
		cube.longi=longi;
		cube.nom=texte;
		cube.position.y=alti*echelleZ;
		cube.ciblePossible=true;
		scene.add( cube );
		return cube;
}

var tObjFixe=new Array();
var tFilFixe=new Array();

var tSpheresJaunes=new Object();
tSpheresJaunes.coul=0xFFFF00;
tSpheresJaunes.r=400;
tSpheresJaunes.prof=-300;
tSpheresJaunes.latLong=new Array();
tSpheresJaunes.latLong=[ 42.929909,   6.349609,
						42.904698,   6.332421,
						 42.905778,   6.319628,
						  42.896805,   6.288945];

function creeSpheresJaunes() {
	// spheres jaunes
	var n=tSpheresJaunes.latLong.length;
	var lati,longi;
	for (var i=0;i<n;i++) {
		lati=tSpheresJaunes.latLong[i*2];
		longi=tSpheresJaunes.latLong[i*2+1];
		tObjFixe.push (ajouteSphere (lati,longi,tSpheresJaunes.prof,tSpheresJaunes.r,tSpheresJaunes.coul,0.5,"Localisation par Bombyx"));
	}
}


function creeUTLN () {
	var a=1000;
	var b=500;
	var c=1000;
	var opa=100;
	var alti=0;
	var coul=0x0000ff;
	var lati=43.136;
	var longi=6.018;
	var texte= "Université de Toulon (UTLN)";
	cubeUTLN=ajouteCube (lati,longi,alti,a,b,c,coul,opa,texte);
	tObjFixe.push (cubeUTLN);
}

function creeAntares() {
	var lati= 42.799286;
	var longi=  6.167188;
	
	var profFond=-2480;
	var profMax=profFond+100;
	var profMin=profFond+480;
	var r=80;
	var r2=400;
	var prof;
	
	var couleur=0x00FF55;
	
	var texte="Antares\n(Astronomy with a Neutrino Telescope and Abyss environmental RESearch)";
	
	var n=6;
	var lati,longi;
	for (var i=0;i<n;i++) {
		prof=(profMax*i+profMin*(n-i-1))/(n-1);
		if (i==0) {
			objAntares=ajouteSphere (lati,longi,prof,r2,couleur,0.5,texte);
			tObjFixe.push (objAntares);
		} else {
			tObjFixe.push (ajouteSphere (lati,longi,prof,r,couleur,0.5,texte));
		}
	}
	
	// fil 
	ajoutFil (lati,longi,profFond,lati,longi,profMin,couleur,0.5);
}

function creeCachalotVuParDrone () {
	objCachalot20180812=ajouteSphere (42.98,5.82,200,500,0xFFFFFF,0.4,"12 Aug 2018");
	tObjFixe.push (objCachalot20180812);
	
}

function creeBombyx() {
	//var lati=  42.937;
	//var longi=    6.317;
	var lati=latiRef;
	var longi=longiRef;
	
	var profFond=-490;
	var prof=-25;
	var r1=200;
	var r2=400;

	var couleur=0xFF0000;
	
	// demi spheres rayon	
	tDemiSph.push( ajoutDemiSph(lati,longi,altiDemi,20000,0xFFFF00,opaDemi,"",2) );
	tDemiSph.push( ajoutDemiSph(lati,longi,altiDemi,10000,0xFF0000,opaDemi,"",1) );
	
	tObjFixe.push (ajouteSphere (lati,longi,profFond,r1,couleur,0.5,"Bombyx"));
	objBombyx=ajouteSphere (lati,longi,prof,r2,couleur,0.5,"Bombyx")
	tObjFixe.push (objBombyx);
	
	// fil 
	ajoutFil (lati,longi,profFond,lati,longi,prof,couleur,0.5);
}

function creeMEUST() {
	var lati=  42.791;
	var longi=    6.022;
		
	var profFond=-2480;
	var profMax=profFond+100;
	var profMin=profFond+480;
	var r=80;
	var r2=400;
	var prof;
	
	var couleur=0x00FFFF;
	
	// demi spheres rayon	
	tDemiSph.push( ajoutDemiSph(lati,longi,altiDemi,20000,0xFFFF00,opaDemi,"",2) );
	tDemiSph.push( ajoutDemiSph(lati,longi,altiDemi,10000,0xFF0000,opaDemi,"",1) );
	
	var n=6;
	var lati,longi;
	var texte="MEUST\n(Mediterranean Eurocentre for Underwater Sciences)";
	for (var i=0;i<n;i++) {
		prof=(profMax*i+profMin*(n-i-1))/(n-1);
		if (i==0) {
			objMEUST=ajouteSphere (lati,longi,prof,r2,couleur,0.5,texte);
			tObjFixe.push (objMEUST);
		} else {
			tObjFixe.push (ajouteSphere (lati,longi,prof,r,couleur,0.5,texte));
		}
	}
	
	// fil 
	ajoutFil (lati,longi,profFond,lati,longi,profMin,couleur,0.5);
}

function remonteCone(geometry,h) {
	var n=geometry.vertices.length;
	for (var i=0;i<n;i++) {
		geometry.vertices[i].y+=h;
	}
}

function creeJonctionWifi() {
	var lati1=  43.155426; // jardin rayol
	var longi1=    6.480596;
	var alti1=50;
	
	var lati2=   43.008638; // fort de l'éminence
	var longi2=    6.388278;
	var alti2=50;
	
	var hAntenne=1000;
	var rAntenne=200;
	
	var couleur=0xFFFFFF;
	
	var c={};
	var xy={};
	
	// antennes = cônes
	var geometry = new THREE.CylinderGeometry( rAntenne/4, rAntenne, hAntenne, 10 );
	remonteCone(geometry,hAntenne/2);
	var material = new THREE.MeshPhongMaterial( {
		color: couleur,
		emissive: couleur,
		transparent : true,
		opacity:0.5
	} );
	
	// rayol
	c.lati=lati1;
	c.longi=longi1;
	xy=latlong2xy(c);
	var x1=xy.x;
	var z1=-xy.y;
	var y1=alti1*echelleZ; // la référence d'un cylindre est au centre
	
	var cone = new THREE.Mesh( geometry, material );
	
	cone.position.x=x1;
	cone.position.z=z1;
	cone.position.y=y1;
	cone.alti=alti1;
	
	cone.ciblePossible=true;
	cone.lati=lati1;
	cone.longi=longi1;
	cone.nom="Antenne WI-FI";
	tObjFixe.push (cone);
	scene.add( cone );
	
	// éminence
	c.lati=lati2;
	c.longi=longi2;
	xy=latlong2xy(c);
	var x2=xy.x;
	var z2=-xy.y;
	var y2=alti2*echelleZ;
	
	var cone = new THREE.Mesh( geometry, material );
	
	cone.position.x=x2;
	cone.position.z=z2;
	cone.position.y=y2;
	cone.alti=alti2;
	
	cone.ciblePossible=true;
	cone.lati=lati2;
	cone.longi=longi2;
	cone.nom="Antenne WI-FI";
	tObjFixe.push (cone);
	scene.add( cone );	
	
	// fil 
	ajoutFil (lati1,longi1,alti1,lati2,longi2,alti2,0xFFFFFF,0.3,hAntenne);
}

function ajoutFil (lati1,longi1,alti1,lati2,longi2,alti2,coul,opa,dy) {
	dy=dy||0;
	var c=new Object();
	var xy=new Object ();
	c.lati=lati1;
	c.longi=longi1;
	xy=latlong2xy(c);
	var x1=xy.x;
	var z1=-xy.y;
	var y1=alti1*echelleZ;

	c.lati=lati2;
	c.longi=longi2;
	xy=latlong2xy(c);
	var x2=xy.x;
	var z2=-xy.y;
	var y2=alti2*echelleZ;
	
	var geometry = new THREE.Geometry();
	geometry.vertices.push(new THREE.Vector3(x1, y1+dy, z1));
	geometry.vertices.push(new THREE.Vector3(x2, y2+dy, z2));
	var material = new THREE.LineDashedMaterial( {
		color: coul,
		opacity:opa,
		transparent:true
	} );

	var fil =new THREE.Line( geometry, material );
	
		
	fil.alti1=alti1;
	fil.alti2=alti2;
	fil.dy=dy;

	scene.add( fil );
	tFilFixe.push (fil);
}

function creeObjetsFixes () {
	creeSpheresJaunes();

	creeAntares();
	creeBombyx();
	creeCachalotVuParDrone();
	creeUTLN();
	creeMEUST();
	creeCachalots();
	creeJonctionWifi();
}

function updateEchDemiSph () {
	for (var i=0;i<tDemiSph.length;i++) {
		tDemiSph[i].scale.set(1,echelleZ,1);
		tDemiSph[i].position.y=tDemiSph[i].alti*echelleZ;
	}
}


function updateEchObjFixes () {
	for (var i=0;i<tObjFixe.length;i++) {
		tObjFixe[i].position.y=tObjFixe[i].alti*echelleZ;
	}
}

function updateEchFils () {
	for (var i=0;i<tFilFixe.length;i++) {
		var f=tFilFixe[i];
		f.geometry.vertices[0].y=f.alti1*echelleZ+f.dy;
		f.geometry.vertices[1].y=f.alti2*echelleZ+f.dy;
		f.geometry.verticesNeedUpdate = true;
	}
	
}