﻿var textSegmentsBruts=new Array();
var textSegments=new Array();
var segmentsCharges=false;
var segmentsDansScene=false;
var currentTimeline={};

var timeline=new Array();

function loadSegments(){
	textFile="segments.csv?x='"+Math.random()+"'";
	var xhr=new XMLHttpRequest;
	xhr.open('GET',textFile,false);
	xhr.onload=function () {
		var text = this.responseText;
		if (xhr.status == "404") {
			alert ("File "+textFile+" not found");
		} else {
			textSegmentsBruts = text.split("\n"); 	
			//console.log ("segments chargés");
			segmentsCharges=true;
			filtreSegments ();
		}
		
	}
	xhr.send();
}
// rappel format : 2016, 07, 10, 8.5, 11.2, 5000, -3000, -500, 5050, -3000, -500 
function filtreSegments () {
	var n=0;
	for (var i=0;i<textSegmentsBruts.length;i++) {
		//console.log (i);
		var l=textSegmentsBruts[i];
		var ligne=l.split(",");
		
		// avec le filtre par URL on ne garde que des valeurs entières numériques
		var sAnnee=ligne[0]*1+"";
		var sMois=ligne[1]*1+"";
		var sJour=ligne[2]*1+"";
		var sHeure=Math.floor(ligne[3])+"";
		
		if ((selYear.includes(sAnnee)||allYear)&&(selMonth.includes(sMois)||allMonth)&&(selHour.includes(sHeure)||allHour)) {
			textSegments[n]=l;
			n++;
		}
	}
	creeTimeline();
}

// rappel format : 2016, 07, 10, 8.5, 11.2, 5000, -3000, -500, 5050, -3000, -500 
function creeTimeline () {
	var n=0;
	for (var i=0;i<textSegments.length;i++) {
		var l=textSegmentsBruts[i];
		var ligne=l.split(",");
		var sAnnee=ligne[0];
		var sMois=code2(ligne[1]*1);
		var sJour=code2(ligne[2]*1);
		var sHeure=code2(Math.floor(ligne[3]));
		var sDate=sAnnee+""+sMois+""+sJour; // date en alphanumérique
		if ((i==0) || ((sDate!=timeline[n-1].sDate)||(sHeure!=timeline[n-1].sHeure))) {
			// nouvelle date
			timeline[n]={};
			timeline[n].sDate=sDate;
			timeline[n].sJour=sJour;
			timeline[n].sAnnee=sAnnee;
			timeline[n].sHeure=sHeure;
			timeline[n].sMois=sMois;
			n++;
		}
		
	}
	document.getElementById("rangeTime").max=timeline.length-1;
	bougeTempsCurseur();
}

function ajouteSegmentsScene() {
	segmentsDansScene=true;
	// on retire tous les segments et sphères de la scène
	for (var i=0;i<tSegments.length;i++) {
		scene.remove( tSegments[i] );
		scene.remove(tSphereSeg[i]);
	}
	tSegments.length=0;
	tSphereSeg.length=0;
	
	//console.log ("segments ajoutés");
	for (var i=0;i<textSegments.length;i++) {
		//console.log (i);
		var l=textSegments[i];
		var ligne=l.split(",");
		var sAnnee=ligne[0];
		var sMois=code2(ligne[1]*1);
		var sJour=code2(ligne[2]*1);
		var sHeure=code2(Math.floor(ligne[3]));
		var sDate=sAnnee+""+sMois+""+sJour; // date en alphanumérique
		var heureDec=ligne[3];
		var sMinutes=code2(Math.round(((heureDec*1)%1)*60));
		var taille=ligne[4]*1;
		
		if ((taille>0)&&(currentTimeline.sDate==sDate)&&(currentTimeline.sHeure==sHeure)) { // la date et l'heure correspond au curseur => on rajoute le segment dans la scène
			var ddate=sDate*1; // date en numérique
			
			var x1=ligne[5]*1;
			var y1=ligne[6]*1;
			var z1=ligne[7]*1;
			var x2=ligne[8]*1;
			var y2=ligne[9]*1;
			var z2=ligne[10]*1;
			
			if (taille<10) {taille=10;}
			if (taille>14) {taille=14;}
			
			var coul=tailleToCoul(taille);
			
			var opa=1;

			var nom=sDate+"\n"+sHeure+":"+sMinutes+" UTC\nPhyseter track\n(size : "+taille+"m)";
			//console.log (x1+" "+y1+" "+z1);
			tSphereSeg.push (ajouteSphereRelSeg (x1,y1,z1,500,coul,opa,nom,ddate,sHeure,sMinutes));
			creeSegmentTubeXY (x1,y1,z1,x2,y2,z2,coul,opa);
		}
		
	}
}
var tSphereSeg=new Array();
function ajouteSphereRelSeg (dx,dy,alti,r,coul,opa,nom,ddate,heure,minutes) {
		var c=new Object();
		var nom=nom||"(sans nom)";
		var xy=new Object();
		var geometry = new THREE.SphereGeometry( r, 16,16 );
		var material = new THREE.MeshPhongMaterial( {
			color: coul,
			emissive: coul&0x3f3f3f,
			transparent : true,
			opacity:opa
		} );
		
		var sphere = new THREE.Mesh( geometry, material );
		
		c.lati=latiRef;
		c.longi=longiRef;
		xy=latlong2xy(c);
		
		xy.x+=dx;
		xy.y+=dy;
		
		x=xy.x;
		z=-xy.y;
		
		sphere.position.x=x;
		sphere.position.z=z;
		sphere.alti=alti;
		sphere.dx=dx;
		sphere.dy=dy;
		sphere.posRel=true;
		sphere.nom=nom;
		sphere.ddate=ddate;
		sphere.heure=heure;
		sphere.minutes=minutes;
		sphere.position.y=alti*echelleZ;
		sphere.ciblePossible=true;
		scene.add( sphere );
		return sphere;
}

var tSegments=new Array();
function creeSegmentTubeXY (x1,y1,z1,x2,y2,z2,coul,opa) {
	var c=new Object();

	c.lati=latiRef;
	c.longi=longiRef;
	var xy=latlong2xy(c);
		
	var xx1=x1*1+xy.x*1;
	var xx2=x2*1+xy.x*1;
	
	var yy1=y1*1+xy.y*1;
	var yy2=y2*1+xy.y*1;
	
	//console.log ("yy1="+yy1);
	
	var xA=xx1;
	var zA=-yy1;
	
	var xB=xx2;
	var zB=-yy2;
	
	var yA=0;
	var yB=0;

	//console.log (xA+" "+xB+" "+yA+" "+yB+" "+zA+" "+zB);
	
	var line=new three3DExtras.tubeLine([xA,yA,zA],[xB,yB,zB],100,coul);
	var fil=line.getObject3D();
	
	fil.ciblePossible=false;
		
	scene.add( fil );
	tSegments.push (fil);
}







function creeSegment (lati1,longi1,alti1,lati2,longi2,alti2,coul,opa,dy) {
	dy=dy||0;
	var c=new Object();
	var xy=new Object ();
	c.lati=lati1;
	c.longi=longi1;
	xy=latlong2xy(c);
	var x1=xy.x;
	var z1=-xy.y;
	var y1=alti1*echelleZ;

	c.lati=lati2;
	c.longi=longi2;
	xy=latlong2xy(c);
	var x2=xy.x;
	var z2=-xy.y;
	var y2=alti2*echelleZ;
	
	var geometry = new THREE.Geometry();
	geometry.vertices.push(new THREE.Vector3(x1, y1+dy, z1));
	geometry.vertices.push(new THREE.Vector3(x2, y2+dy, z2));
	
	var material = new THREE.LineBasicMaterial({
            color: coul,
			opacity:opa,
			linewidth: 4,
			transparent:true
    });
	
	var fil =new THREE.Line( geometry, material );
	
	scene.add( fil );
	tSegments.push (fil);
}

function creeSegmentTube (lati1,longi1,alti1,lati2,longi2,alti2,coul,opa,dy) {
	dy=dy||0;
	var c=new Object();
	var xy=new Object ();
	c.lati=lati1;
	c.longi=longi1;
	xy=latlong2xy(c);
	var x1=xy.x;
	var z1=-xy.y;
	var y1=alti1*echelleZ;

	c.lati=lati2;
	c.longi=longi2;
	xy=latlong2xy(c);
	var x2=xy.x;
	var z2=-xy.y;
	var y2=alti2*echelleZ;
	

	var line=new three3DExtras.tubeLine([x1,y1+dy,z1],[x2,y2+dy,z2],100,coul);
	var fil=line.getObject3D();
	
	fil.nom="trajet bla bla bla";
	fil.ciblePossible=true;
		
	scene.add( fil );
	tSegments.push (fil);
}



function code2 (nn) {
	var n=nn*1;
	if (n<10) {return "0"+n;} else {return n;}
}