﻿function startGL () {
	
		clock = new THREE.Clock();
	 
		// camera
		camera = new THREE.PerspectiveCamera(35, lGL / hGL, 10, 1000000);
		  
		// renderer
		renderer = new THREE.WebGLRenderer({ antialias: true });
		renderer.setClearColor( 0xffffff, 1 );
		renderer.setSize(lGL,hGL);

		divgl.appendChild(renderer.domElement);

		// scene
		scene = new THREE.Scene();
		scene.fog = new THREE.Fog( 0xffffff, distCam,distCam*2);
}

function render()	{
	// render
	renderer.render(scene, camera);	
}

function legende (x,y,texte) {
	var l=lGL*0.01;
	var hFont=Math.round(hGL*0.12)/10;
	ctx.font=Math.round(hFont)+"px Arial";
	ctx.strokeStyle="rgba(255,255,255,0.6)";
	ctx.beginPath();
	ctx.moveTo (x,y);
	x+=l;
	y-=l;
	ctx.lineTo (x,y);
	x+=l;
	ctx.lineTo (x,y);
	ctx.stroke();
	y+=hFont*0.3;
	x+=hFont*0.3;
	ctx.fillStyle="rgba(255,255,255,0.6)";
	ctx.fillText (texte,x+1,y+1);
}

function legendeObj (objet,texte) {
	var proj = toScreenPosition(objet, camera);
	x=proj.x;
	y=proj.y;
	legende (x,y,texte);
}

function afficheLegende() {
	ctx.clearRect (0,0,lGL,hGL);
	legendeObj (cubeUTLN,"UTLN");
	legendeObj (objBombyx,"BOMBYX");
	legendeObj (objMEUST,"MEUST");
	legendeObj (objAntares,"ANTARES");
	for (var i=0;i<tSphereSeg.length;i++) {
		var o=tSphereSeg[i];
		var heureUTC=o.heure;
		var texte=o.ddate+" "+heureUTC+":"+o.minutes+"UTC";
		legendeObj (o,texte);
	}
}

		
function animate(){
	var delta = clock.getDelta();
	//temps+=delta*vitesse;
	//bougeMobile();
	if ((segmentsCharges==true)&&(segmentsDansScene==false)) {ajouteSegmentsScene();}
	bougeCam();
	afficheLegende ();
	requestAnimationFrame( animate );
	render();		
}
		
		
function toScreenPosition(obj, camera)
{
    var vector = new THREE.Vector3();

    var widthHalf = 0.5*renderer.context.canvas.width;
    var heightHalf = 0.5*renderer.context.canvas.height;

    obj.updateMatrixWorld();
    vector.setFromMatrixPosition(obj.matrixWorld);
    vector.project(camera);

    vector.x = ( vector.x * widthHalf ) + widthHalf;
    vector.y = - ( vector.y * heightHalf ) + heightHalf;

    return { 
        x: vector.x,
        y: vector.y
    };

};