# 
# Copies and converts files from log to wav
# File source can be different from destination (eg external drive to server)
# 

import os
from pathlib import Path
import argparse

# Defaults
SRC_ROOT = "/Volumes/Elements/"
LOCAL_ROOT = "/Users/patrickmclean/GPDev/bioacoustics/mks/plots/"
SERVER_ROOT = "D:/Bioacoustics/Projects/mks/plots/"
sub_dir = "plot1/20220926/"             # Set as blank to process everything in the root_dir
ch = 2                                  # Channel to be processed, using numbering [1,2,3,4]

####################
# Main #
####################

# Read command line arguments, otherwise we use the default values
env = os.getenv("GPSVR")
argParser = argparse.ArgumentParser()
argParser.add_argument("-d", "--dir", required=False, help="sub directory to process")
argParser.add_argument("-v", "--vol", required=False, help="name of external volume")
args = vars(argParser.parse_args())
if args['dir'] != None:
    sub_dir = args['dir']
if args['vol'] != None:
    SRC_ROOT = f"/Volumes/{args['vol']}/"

# These represent the project root directories (plots should be next level down)
drive_src_root = "/Volumes/Elements/"
drive_dst_root = "/Users/patrickmclean/GPDev/bioacoustics/data/mks"
src_root_dir = SRC_ROOT + sub_dir
dst_root_dir = (SERVER_ROOT if env == "SERVER" else LOCAL_ROOT)

# Perform log2wav on all log files under the root directory
for root, dirs, files in os.walk(src_root_dir):
    path = root.split(os.sep)
    dir = os.path.basename(root)
    if dir == "log":
        # Create destination directory
        parent = Path(root).parent.absolute()
        cur_date = os.path.basename(parent)
        cur_plot = os.path.basename(parent.parent.absolute())
        dst_plot = os.path.join(dst_root_dir,f"{cur_plot}/{cur_date}/wav")
        print(f"Creating destination directory: {dst_plot}")
        os.makedirs(dst_plot, exist_ok=True)

        # process files
        for file in files:
            if file.endswith(".log"):
                root_parent = os.path.abspath(os.path.join(root, os.pardir))
                dst_file = file.replace(".log", ".wav")
                command = f"log2wav {root}/{file} {dst_plot}/{dst_file}"
                #print(f"Processing: {command}")
                if os.path.exists(f"{dst_plot}/{dst_file}"):
                    print(f"Skipping {file} as it already exists")
                else:
                    print(f"processing {file}")
                    stream = os.popen(command)
                    output = stream.read()
                    if output:
                        print(f"op: {output.splitlines()[-1]}")
                    else:
                        print(f"Error processing {file}")
                    